﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Newtonsoft.Json;
using Ext.Net;
using System.IO;
using System.Data;
using DataAccess;
using System.Collections;
using System.Web.Script.Serialization;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "UCEVTENTRY")]

public partial class ucEventEntry : System.Web.UI.UserControl
{
    public BaseMaster BaseMstr { get; set; }

    
    /// <summary>
    /// US:6942 Event entry type id property
    /// </summary>
    public string EventEntryTypeID
    {
        get
        {
            string strValue = "";
            if (Session["UCEEEventEntryTypeID"] != null)
            {
                strValue = Session["UCEEEventEntryTypeID"].ToString();
            }

            return strValue;
        }
        set { Session["UCEEEventEntryTypeID"] = Convert.ToString(value); }
    }

    /// <summary>
    /// US:6942 event entry id
    /// </summary>
    public string EventEntryID
    {
        get
        {
            string strValue = "";
            if (Session["UCEEEventEntryID"] != null)
            {
                strValue = Session["UCEEEventEntryID"].ToString();
            }

            return strValue;
        }
        set { Session["UCEEEventEntryID"] = Convert.ToString(value); }
    }
    /// <summary>
    /// US:6942 user id who wrote this entry
    /// </summary>
    public string FXUserID
    {
        get
        {
            string strValue = "";
            if (Session["UCEEFXUserID"] != null)
            {
                strValue = Session["UCEEFXUserID"].ToString();
            }

            return strValue;
        }
        set { Session["UCEEFXUserID"] = Convert.ToString(value); }
    }

    /// <summary>
    /// US:6942 Patient pathway id property
    /// </summary>
    public string PatPWID
    {
        get
        {
            string strValue = "";
            if (Session["UCEEPatPWID"] != null)
            {
                strValue = Session["UCEEPatPWID"].ToString();
            }

            return strValue;
        }
        set { Session["UCEEPatPWID"] = Convert.ToString(value); }
    }

    /// <summary>
    /// US:6942 Pathway event id property
    /// </summary>
    public string PatPWEventID
    {
        get
        {
            string strValue = "";
            if (Session["UCEEPatPWEventID"] != null)
            {
                strValue = Session["UCEEPatPWEventID"].ToString();
            }

            return strValue;
        }
        set { Session["UCEEPatPWEventID"] = Convert.ToString(value); }
    }

    /// <summary>
    /// US:6942 Pathway event module id property
    /// </summary>
    public string PWEventModuleID
    {
        get
        {
            string strValue = "";
            if (Session["UCEEPWEventModuleID"] != null)
            {
                strValue = Session["UCEEPWEventModuleID"].ToString();
            }

            return strValue;
        }
        set { Session["UCEEPWEventModuleID"] = Convert.ToString(value); }
    }

    /// <summary>
    /// US:6942 edit mode: UPDATE or INSERT
    /// </summary>
    public string PWEventEntryEditMode
    {
        get
        {
            string strValue = "";
            if (Session["UCEEPWEventEntryEditMode"] != null)
            {
                strValue = Session["UCEEPWEventEntryEditMode"].ToString();
            }

            return strValue;
        }
        set { Session["UCEEPWEventEntryEditMode"] = Convert.ToString(value); }
    }


    /// <summary>
    /// US:6942 US:7004	show the event entry popup for a new entry
    /// </summary>
    /// <param name="strPWEventModuleID"></param>
    public void OnNewEntry( long lEventEntryTypeID,
                            string strPatientID,
                            long lPatPWID,
                            long lPatPWEventID,
                            long lPWEventModuleID,
                            long lStatusID,
                            long lSeverityID,
                            string strModule )
    {
        //set the edit mode
        PWEventEntryEditMode = "INSERT";

        //cache values for the save
        EventEntryTypeID = Convert.ToString(lEventEntryTypeID);
        PatPWID = Convert.ToString(lPatPWID);
        PatPWEventID = Convert.ToString(lPatPWEventID);
        PWEventModuleID = Convert.ToString(lPWEventModuleID);

        //pre-select the date to today
        dfUCEEDate.SelectedDate = DateTime.Now;
        tfUCEEDate.SelectedTime = DateTime.Now.TimeOfDay; 
        tfUCEEComment.Text = "";

        //select the status
        cboUCEEStatus.SelectedItems.Clear();
        Ext.Net.ListItem itmStatus = new Ext.Net.ListItem();
        itmStatus.Value = Convert.ToString(lStatusID);
        itmStatus.Mode = ParameterMode.Raw;
        cboUCEEStatus.SelectedItems.Add(itmStatus);
        cboUCEEStatus.UpdateSelectedItems();

        //select the severity
        cboUCEESeverity.SelectedItems.Clear();
        Ext.Net.ListItem itmSeverity = new Ext.Net.ListItem();
        itmSeverity.Value = Convert.ToString(lSeverityID);
        itmSeverity.Mode = ParameterMode.Raw;
        cboUCEESeverity.SelectedItems.Add(itmSeverity);
        cboUCEESeverity.UpdateSelectedItems();

        //select the templates
        cboUCEETemplate.SelectedItems.Clear();
        cboUCEETemplate.UpdateSelectedItems();

        wndUCEE.Title = strModule + " - Add/Edit Entry";
        
        //show the data entry dialog
        wndUCEE.Center();
        wndUCEE.Show();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:6942 user clicked the save button
    /// </summary>
    public void OnEntrySelect()
    {
        //get the pathway event
    //    CCPA cpa = new CCPA();
    //    DataSet ds = cpa.GetPatPWEventByIDDS(BaseMstr,
    //                                         BaseMstr.SelectedPatientID,
    //                                         CDataUtils2.ToLong(PatPWEventID));

        //show/hide buttons as needed
    //    if (!CDataUtils2.IsEmpty(ds))
    //    {
        //    long lStatus = CDataUtils2.GetDSLongValue(ds, "STATUS");
            if (BaseMstr.EventStatus == 2)
            {
                btnuCEDelete.Disable();
                btuCEEdit.Disable();
            }
            else
            {
                btnuCEDelete.Enable();
                btuCEEdit.Enable();
            }
      //  }
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:6942 user clicked the save button
    /// </summary>
    public void OnSave()
    {
        if (tfUCEEComment.Text.Length < 1)
        {
            BaseMstr.ShowSystemFeedback("Please enter a valid comment!", "Error");
            return;
        }

        DateTime dtEntry = dfUCEEDate.SelectedDate;
        if (dtEntry.Year == 1)
        {
            BaseMstr.ShowSystemFeedback("Please select a valid date!", "Error");
            return;
        }

        if (cboUCEEStatus.SelectedItem.Value == null)
        {
            BaseMstr.ShowSystemFeedback("Please select a valid status!", "Error");
            return;
        }

        if (cboUCEESeverity.SelectedItem.Value == null)
        {
            BaseMstr.ShowSystemFeedback("Please select a valid Functional Limitation!", "Error");
            return;
        }

        //build a date time
        TimeSpan tsEntry = tfUCEEDate.SelectedTime;
        DateTime dtEntryDateTime = new DateTime(dtEntry.Year, dtEntry.Month, dtEntry.Day,
                                                tsEntry.Hours, tsEntry.Minutes, tsEntry.Seconds);

        CPWEvent evt = new CPWEvent();
      
        //insert a new entry
        if (PWEventEntryEditMode == "INSERT")
        
        {
            long lEventEntryID = evt.InsertPWEventEntry(BaseMstr,
                                                        CDataUtils2.ToLong(PatPWEventID),
                                                        CDataUtils2.ToLong(PWEventModuleID),
                                                        CDataUtils2.ToLong(EventEntryTypeID),
                                                        dtEntryDateTime,
                                                        tfUCEEComment.Text,
                                                        CDataUtils2.ToLong(cboUCEEStatus.SelectedItem.Value),
                                                        CDataUtils2.ToLong(cboUCEESeverity.SelectedItem.Value));

            if (lEventEntryID < 1)
            {

                BaseMstr.ShowSystemFeedback("Failed to save entry!", "Error");
                return;
            }
            else
            {
                //reload the list
                InitializeControl(CDataUtils2.ToLong(PatPWEventID));

                Ext.Net.MessageBus.Default.Publish("MBL_RELOADOUTCOMES");
            }
        }

        //update an entry
        if (PWEventEntryEditMode == "UPDATE")
        {
            DateTime dtEventDate = dfUCEEDate.SelectedDate;

            if (!evt.UpdatePWEventEntry(BaseMstr,
                                       CDataUtils2.ToLong(EventEntryID),
                                       CDataUtils2.ToLong(PWEventModuleID),
                                       CDataUtils2.ToLong(EventEntryTypeID),
                                       dtEntryDateTime,
                                       tfUCEEComment.Text,
                                       CDataUtils2.ToLong(cboUCEEStatus.SelectedItem.Value),
                                       CDataUtils2.ToLong(cboUCEESeverity.SelectedItem.Value)))
            {

                BaseMstr.ShowSystemFeedback("Failed to save entry!", "Error");
                return;
            }
            else
            {
                //reload the list
                InitializeControl(CDataUtils2.ToLong(PatPWEventID));

                Ext.Net.MessageBus.Default.Publish("MBL_RELOADOUTCOMES");
            }
        }
        
        wndUCEE.Close();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:6942 user clicked the cancel button
    /// </summary>
    public void OnCancel()
    {
        wndUCEE.Close();
    }


    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:6942 US:7004 edit an entry
    /// </summary>
    public void OnEditEntry(string strJsonRecord)
    {
        string strRec = strJsonRecord;
        //.Replace("[", "").Replace("]", "");

        if (strRec.Length > 2)
        {
            if (strRec.Substring(0, 1) == "[")
            {
                strRec = strRec.Substring(1);
            }

            if (strRec.Substring(strRec.Length - 1, 1) == "]")
            {
                strRec = strRec.Substring(0, strRec.Length - 1);
            }
        }


        //set the edit mode
        PWEventEntryEditMode = "UPDATE";

        //get data from the record
        string strPatPWEventEntryID = CDataUtils2.GetJsonRecordValue("PAT_PW_EVENT_ENTRY_ID", strRec);
        string strPatientID = CDataUtils2.GetJsonRecordValue("PATIENT_ID", strRec);
        string strPatPWID = CDataUtils2.GetJsonRecordValue("PAT_PW_ID", strRec);
        string strPatPWEventID = CDataUtils2.GetJsonRecordValue("PAT_PW_EVENT_ID", strRec);
        string strEventEntryTypeID = CDataUtils2.GetJsonRecordValue("EVENT_ENTRY_TYPE_ID", strRec);
        string strEventComment = CDataUtils2.GetJsonRecordValue("EVENT_COMMENT", strRec);
        string strFXUserID = CDataUtils2.GetJsonRecordValue("FX_USER_ID", strRec);

        string strEventDate = CDataUtils2.GetJsonRecordValue("EVENT_DATE", strRec);
        DateTime dtEventDate = System.Runtime.Remoting.Metadata.W3cXsd2001.SoapDateTime.Parse(strEventDate);

        string strEventStatusID = CDataUtils2.GetJsonRecordValue("EVENT_STATUS_ID", strRec);
        string strEventSeverityID = CDataUtils2.GetJsonRecordValue("EVENT_SEVERITY_ID", strRec);

        string strPWEventModuleID = CDataUtils2.GetJsonRecordValue("PW_EVENT_MODULE_ID", strRec);
        string strUserName = CDataUtils2.GetJsonRecordValue("USER_NAME", strRec);
        string strUserTitle = CDataUtils2.GetJsonRecordValue("USER_TITLE", strRec);
        string strEventEntryType = CDataUtils2.GetJsonRecordValue("EVENT_ENTRY_TYPE", strRec);
        string strModule = CDataUtils2.GetJsonRecordValue("MODULE", strRec);
    
        //cache values for the update
        EventEntryID = strPatPWEventEntryID;
        FXUserID = strFXUserID;
        EventEntryTypeID = strEventEntryTypeID;
        PatPWID = strPatPWID;
        PatPWEventID = strPatPWEventID;
        PWEventModuleID = strPWEventModuleID;
       
        //pass values to the popup
        
        //date
        dfUCEEDate.SelectedDate = dtEventDate;
        tfUCEEDate.SelectedTime = dtEventDate.TimeOfDay; 

        //status, default to unk if not set
        if (String.IsNullOrEmpty(strEventStatusID))
        {
            strEventStatusID = "0";
        }
        cboUCEEStatus.SelectedItems.Clear();
        Ext.Net.ListItem itmStatus = new Ext.Net.ListItem();
        itmStatus.Value = strEventStatusID;
        itmStatus.Mode = ParameterMode.Raw;
        cboUCEEStatus.SelectedItems.Add(itmStatus);
        cboUCEEStatus.UpdateSelectedItems();

        //severity, default to unk if not set
        if (String.IsNullOrEmpty(strEventSeverityID))
        {
            strEventSeverityID = "0";
        }
        cboUCEESeverity.SelectedItems.Clear();
        Ext.Net.ListItem itmSeverity = new Ext.Net.ListItem();
        itmSeverity.Value = strEventSeverityID;
        itmSeverity.Mode = ParameterMode.Raw;
        cboUCEESeverity.SelectedItems.Add(itmSeverity);
        cboUCEESeverity.UpdateSelectedItems();

        //clear template selection
        cboUCEETemplate.SelectedItems.Clear();
        cboUCEETemplate.UpdateSelectedItems();

        //comment text
        tfUCEEComment.Text = strEventComment;

        wndUCEE.Title = strModule + " - Add/Edit Entry";

        //show the window
        wndUCEE.Center();
        wndUCEE.Show();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:6942 delete an entry
    /// </summary>
    public void OnDeleteEntry(string strJsonRecord)
    {
        string strRec = strJsonRecord;
        //.Replace("[", "").Replace("]", "");

        if (strRec.Length > 2)
        {
            if (strRec.Substring(0, 1) == "[")
            {
                strRec = strRec.Substring(1);
            }

            if (strRec.Substring(strRec.Length - 1, 1) == "]")
            {
                strRec = strRec.Substring(0, strRec.Length - 1);
            }
        }

        //get data from the record
        string strPatPWEventEntryID = CDataUtils2.GetJsonRecordValue("PAT_PW_EVENT_ENTRY_ID", strRec);
        string strPatientID = CDataUtils2.GetJsonRecordValue("PATIENT_ID", strRec);
        string strPatPWID = CDataUtils2.GetJsonRecordValue("PAT_PW_ID", strRec);
        string strPatPWEventID = CDataUtils2.GetJsonRecordValue("PAT_PW_EVENT_ID", strRec);
        string strEventEntryTypeID = CDataUtils2.GetJsonRecordValue("EVENT_ENTRY_TYPE_ID", strRec);
        string strEventComment = CDataUtils2.GetJsonRecordValue("EVENT_COMMENT", strRec);
        string strFXUserID = CDataUtils2.GetJsonRecordValue("FX_USER_ID", strRec);
        string strEventDate = CDataUtils2.GetJsonRecordValue("EVENT_DATE", strRec);
        string strEventStatusID = CDataUtils2.GetJsonRecordValue("EVENT_STATUS_ID", strRec);
        string strPWEventModuleID = CDataUtils2.GetJsonRecordValue("PW_EVENT_MODULE_ID", strRec);
        string strUserName = CDataUtils2.GetJsonRecordValue("USER_NAME", strRec);
        string strUserTitle = CDataUtils2.GetJsonRecordValue("USER_TITLE", strRec);
        string strEventEntryType = CDataUtils2.GetJsonRecordValue("EVENT_ENTRY_TYPE", strRec);

        //delete the entry
        CPWEvent evt = new CPWEvent();
        evt.DeletePWEventEntry(BaseMstr, Convert.ToInt32(strPatPWEventEntryID));

        //reload the list
        InitializeControl(CDataUtils2.ToLong(strPatPWEventID));

        //reload the tree
        Ext.Net.MessageBus.Default.Publish("MBL_RELOADOUTCOMES");
    }

    /// <summary>
    /// US:6942 US:7004 initialize the control
    /// </summary>
    /// <returns></returns>
    public bool InitializeControl(long lPatPWEventID)
    {
        CPWEvent evt = new CPWEvent();
        CTemplate tmpl = new CTemplate();

        PatPWEventID = Convert.ToString(lPatPWEventID);
        
        //load the event entries
        DataSet dsEE = evt.GetEventEntryDS(BaseMstr, lPatPWEventID);
        CDataConverter cdc = new CDataConverter();
        string strJsonRecord = cdc.GetJsonDSString(dsEE);
        storUCEEE.SetDataFromJson(strJsonRecord);

        //load the status
        DataSet dsStatus = evt.GetEventStatusDS(BaseMstr);
        //clear the combo
        cboUCEEStatus.GetStore().RemoveAll();
        cboUCEEStatus.Items.Clear();
        //load the store from the ds
        string strStatusJSON = cdc.GetJsonDSString(dsStatus);
        storeUCEEStatus.SetDataFromJson(strStatusJSON);
      
                
        //load the severity
        DataSet dsSeverity = evt.GetEventSeverityDS(BaseMstr);
        //clear the combo
        cboUCEESeverity.GetStore().RemoveAll();
        cboUCEESeverity.Items.Clear();
        //load the store from the ds
        string strSeverityJSON = cdc.GetJsonDSString(dsSeverity);
        storeUCEESeverity.SetDataFromJson(strSeverityJSON);

        //load the templates
        DataSet dsTemplates = tmpl.GetTemplateDS(BaseMstr, CTemplate.TemplateTypeID.OUTCOMES);
        //clear the combo
        cboUCEETemplate.GetStore().RemoveAll();
        cboUCEETemplate.Items.Clear();
        //load the store from the ds
        string strTemplatesJSON = cdc.GetJsonDSString(dsTemplates);
        storeUCEETemplates.SetDataFromJson(strTemplatesJSON);

        btnuCEDelete.Disable();
        btuCEEdit.Disable();

        RowSelectionModel tm = (RowSelectionModel)gpUCEE.GetSelectionModel();
        tm.SelectedIndex = -1;
        tm.SelectedRow = null;
        tm.SelectedRecordID = "-1";
        tm.ClearSelection();
        tm.UpdateSelection();


        return true;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:7004 Load template selected
    /// </summary>
    /// <param name="strTemplateID"></param>
    public void LoadTemplate(string strTemplateID)
    {
        CTemplate template = new CTemplate();

        if (!String.IsNullOrEmpty(strTemplateID) && !strTemplateID.Equals("null"))
        {
            string strParsedTemplate = template.GetParsedTemplateText2(BaseMstr,
                                                                       BaseMstr.SelectedPatientID,
                                                                       PatPWEventID, 
                                                                       Convert.ToInt32(strTemplateID));

            tfUCEEComment.Text += strParsedTemplate;
            cboUCEETemplate.SelectedItems.Clear();
            cboUCEETemplate.UpdateSelectedItems();

        }
    }

    /// <summary>
    /// US:6942 page load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            btuCEEdit.Disable();
            btnuCEDelete.Disable();
        }

    }
}